<?php
/**
 * OpenSEF for Joomla!
 * @copyright (c) 2005 The OpenSEF Project (www.opensef.org)
 * @copyright (c) 2004-2005 Xaneon Development (www.xaneon.com)
 * @license GPL http://www.gnu.org/copyleft/gpl.html
 *
 * The Rewriter handles outgoing URL rewriting (sefRelToAbs).
 *
 */

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

/** */
@define( '_SEF_REWRITER', 'sefRewriter' );

/*
 * TODO
 */
class sefRewriter extends sefObject {

  /*
   * TODO
   */
  function sefRewriter( &$db, &$config, &$site ) {
    $this->sefObject( $db, $config, $site );
    $this->ignore = array(
      'option=login',
      'option=logout',
      'task=new',
      'task=edit',
      'Itemid=1&limit=',
   );
    $this->cache = array();
  }

  /*
   * TODO
   */
  function rewrite( $string ) {
    if (!($string = $this->normalize( $string )))
      return $string;

    if (!empty( $this->config->cache_outgoing )) {
      if (array_key_exists( $string, $this->cache )) {
        return $this->cache[$string];
      }
      else {
        $url = $this->rewriteNoCache( $string );
        $this->cache[$string] = $url;
        return $url;
      }
    }

    return $this->rewriteNoCache( $string );
  }

  /*
   * TODO
   */
  function normalize( $url ) {
    // if begins with live_site, strip it off
    // if begins with index.php without trailing slash, add slash
    $url = str_replace( '&amp;', '&', $url );
    return $url;
  }

  /*
   * TODO
   */
  function rewriteNoCache( $url ) {
  	global $database, $sefConfig, $mosConfig_absolute_path;

    if (sefIsExternalURL( $url ) || !sefIsJoomlaURL( $url ))
      return $url;

    if ($url == 'index.php')
      return $this->site->base_url . '/';

    // Refuse to process URLs that wouldn't work anyway; see reserved list.
    if (is_array( $this->ignore )) {
      foreach ($this->ignore as $pattern) {
        if (eregi( $pattern, $url ))
          return $url;
      }
    }

    $alias = mosSEFAlias::lookupOutgoing( $this->site->id, $url );
    if ($alias != null && !empty( $alias->published ) && $alias->external != '') {

      $url = $alias->external;
      if ($url[0] == '/') $url = substr($url, 1);

    }
    else {

      $component = null;
      if (ereg( '[\?&]+option=com_([0-9a-zA-Z_\-]+)&', $url, $matches ))
        $component = $matches[1];
      $menu_id = 0;
      if (ereg( '&Itemid=([0-9]+)', $url, $matches ))
        $menu_id = $matches[1];

      switch ($component) {
      	
      	case 'frontpage':
      	  $c = mosSEFComponent::lookup( $this->site->id, $menu_id, 'com_frontpage' );
          if (!is_object( $c ) && empty( $c->alias )) {
      		return $this->site->base_url . '/';
          } else { 
          	return $c->alias . '/';
          }
           		
        case 'content':
           $url = sefRewriteToJoomlaSEF( $url );
          break;
          
        case 'weblinks':
           $url = sefRewriteToJoomlaSEF( $url );
           break; 
        case 'contact':
           $url = sefRewriteToJoomlaSEF( $url );
          break; 
        case 'newsfeeds':
           $url = sefRewriteToJoomlaSEF( $url );
          break; 
        case 'wrapper':
           $url = sefRewriteToJoomlaSEF( $url );
          break;         
       
        case 'registration':
          // TODO: special support.
          
        case 'profiler':
          

        case 'phpshop':
          // TODO: This needs some work as the URLs are pretty borked.
          // Need to file bug reports with the component's maintainer.

        default:
          $c = mosSEFComponent::lookup( $this->site->id, $menu_id, 'com_' . $component );
          if (is_object( $c ) && !empty( $c->alias )) {
          	$path = $c->alias . '/';
          	if (!empty( $this->config->use_sef_ext ))
              sefLoadExtension( $component );
            $class = 'sef_' . $component;
            if (class_exists( $class ) && is_callable( array($class, 'create') )) {
              $url = str_replace( '&', '&amp;', $url );
              $url = call_user_func( array($class, 'create'), $url );
              $url = $path . $url;
            }
            else if (!empty( $GLOBALS['mosConfig_sef'] )) {
              $url = sefRewriteToJoomlaSEF( $url, $path );
            }
          }
          else if (!empty( $GLOBALS['mosConfig_sef'] )) {
            $url = sefRewriteToJoomlaSEF( $url );
          }
          break;

      }
    }

    if (!empty( $this->config->xhtml_compliance )) {
      // This breaks links sent with Joomla's e-mailing, but XHTML
      // freaks may want it anyway.
      $url = str_replace( '&', '&amp;', $url );
    }

    $url = $this->site->base_url . '/' . $url;
    $url = str_replace( '//', '/', $url ); // Just in case.

    if (!empty( $this->config->use_absolute_urls )) {
      $info = parse_url( $GLOBALS['mosConfig_live_site'] );
      $url = $info['scheme'] . '://' .
        (!empty( $this->site->host ) ? $this->site->host : $info['host']) . $url;
    }

    if (!empty( $this->config->use_session_fix )) {
      // TODO: .../sid,xyz/ -> ...?sid=xyz
    }
    return $url;
  }

}

?>